      Subroutine synhr2d( a1, a2, w1, w2, n1, n2 )
! ---------------------------------------------------------------------
! --- Routine 'synhr2d' does a 2-D Haar wavelet synthesis. Matrix 'w2'
!     is input, 'a1' is the result.
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n1, n2
      Real(l_) :: a1(n1,n2), a2(n2,n1), w1(n1,n2), w2(n2,n1)

      Integer  :: i, log2, m
! ---------------------------------------------------------------------
      m  = log2( n2 )
      Do i = 1, n1
         Call synthr( w2(1,i), a2(1,i), n2, m )
      End Do
      Call ltrans( w1, a2, n2, n1 )
      m  = log2( n1 )
      Do i = 1, n2
         Call synthr( w1(1,i), a1(1,i), n1, m )
      End Do
! ---------------------------------------------------------------------
      End Subroutine synhr2d
