      Subroutine ltrans( a, w, n1, n2 )
! ---------------------------------------------------------------------
! --- 'ltrans' does transposition of a rectangular Real*8 matrix.
!     'a' is the input, 'w' is transpose(a). 
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n1, n2
      Real(l_) :: a(n2,n1), w(n1,n2)

      Integer  :: i1, i2, j, nr
! ---------------------------------------------------------------------
      j  = Mod( n2, 4 )
      nr = n2 - j
      Do i1 = 1, n1
         Do i2 = 1, nr, 4
            a(i2  ,i1) = w(i1  ,i2)
            a(i2+1,i1) = w(i1,i2+1)
            a(i2+2,i1) = w(i1,i2+2)
            a(i2+3,i1) = w(i1,i2+3)
         End Do
      End Do
      Do i1 = 1, n1
         Do i2 = nr+1, n2
            a(i2,i1)   = w(i1,i2)
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine ltrans
