      Subroutine anhr2d( a1, a2, w1, w2, n1, n2 )
! ---------------------------------------------------------------------
! --- 'anhr2d' does a 2-D Haar wavelet analysis on array 'a1'.
!      Output in 'a2'.
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n1, n2
      Real(l_) :: a1(n1,n2), a2(n2,n1), w1(n1,n2), w2(n2,n1)

      Integer  :: i, log2, m
! ---------------------------------------------------------------------
      m  = log2( n1 )
      Do i = 1, n2
         Call analhr( a1(1,i), w1(1,i), n1, m )
      End Do
      Call ltrans( a2, w1, n1, n2 )
      m  = log2( n2 )
      Do i = 1, n1
         Call analhr( a2(1,i), w2(1,i), n2, m )
      End Do      
! ---------------------------------------------------------------------
      End Subroutine anhr2d
