      Subroutine gendat( a, n1, n2, actsiz, base )
! ---------------------------------------------------------------------
! --- 'gendat' generates the input data for the Wavelet transform and
!     puts them in array 'a'.
! ---------------------------------------------------------------------
      Use         numerics
      Use         dist_module ! Contains # of proc.s & proc. no.s 
      Implicit    None

      Integer  :: n1, n2
      Real(l_) :: a(n1,n2)
      Integer  :: actsiz(0:nodes-1,2), base(0:nodes-1,2)

      Integer  :: i1, i2, shift
! ---------------------------------------------------------------------
      shift = base(me,2)
      Do i2 = 1, actsiz(me,2)
         Do i1 = 1, n1
            a(i1,i2) = (shift + i2 - 1)*n1 + i1
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine gendat      
