      Program smxv
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Efficiency Benchmark       ***
! ***                                                                ***
! *** Copyright: European Benchmark Group p/o                        ***
! ***            Utrecht University, High Perf. Computing Group      ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Email: steen@phys.uu.nl                                        ***
! *** Date : Spring 1998                                             ***
! **********************************************************************
! ----------------------------------------------------------------------
! --- Sparse Matrix-vector product from a CRS format matrix.
!     The vector to be multplied with and the result vector are assumed
!     to be dense.
! ----------------------------------------------------------------------
      Use                       numerics
      Implicit                  None

      Integer, Allocatable   :: indx(:), rowp(:)
      Real(l_), Allocatable  :: matvals(:), invec(:), outvec(:)
      Real(l_)               :: wclock, time, mflops
      Real(l_), Parameter    :: MICRO = 1.0e-6_l_, TWO = 2.0_l_,
     &                          PERC = 1.0e2_l_
      Integer                :: ncols, nrows, nelmts
      Logical                :: ok
! ----------------------------------------------------------------------
      Call state( 'smxv    ' )
      Open( 1, File = 'smxv.in' )
      Print 1000
   10 Read( 1, *, End = 20 ) ncols, nrows, nelmts
         Allocate( indx(nelmts), rowp(nrows), matvals(nelmts),
     &             invec(ncols), outvec(nrows) )
         Call getmatvec( ncols, nrows, nelmts, indx, rowp, matvals,
     &                   invec )
         time = wclock()
         Call spmxv( nrows, nelmts, indx, rowp, matvals, invec, outvec )
         time   = wclock() - time
         mflops = TWO*MICRO*Real( nelmts, l_ )/time
         ok = .TRUE.
         Call check( ncols, nrows, nelmts, indx, rowp, outvec, ok )
         Deallocate ( indx, rowp, matvals, invec, outvec )
         Print 1010, nrows, ncols,
     &               PERC*Real( nelmts, l_ )/Real( nrows*ncols, l_ ),
     &               time, mflops, ok       
      Go To 10
! ----------------------------------------------------------------------	 
   20 Print 1020
! ----------------------------------------------------------------------
 1000 Format( 'Program smxv: Sparse (CRS) Matrix-vector Multiply'/
     &        '-------------------------------------------------------'/
     &        ' #Rows | #Cols | %Fill |   Time(s)   |   Mflop/s   |OK|'/
     &        '------------------------------------------------------|')
 1010 Format( i7, '|', i7, '|', f6.2, ' |', g13.5, '|', g13.5, '|',  l,
     &        '|' )
 1020 Format( '-------------------------------------------------------') 
! ----------------------------------------------------------------------
      End Program smxv
