      Program qsort
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Efficiency Benchmark       ***
! ***                                                                ***
! *** Copyright: European Benchmark Group p/o                        ***
! ***            Utrecht University, High Perf. Computing Group      ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Email: steen@phys.uu.nl                                        ***
! *** Date : Spring 1998                                             ***
! **********************************************************************
! ----------------------------------------------------------------------
!     Program 'qsort' tests an iterative Quicksort algorithm with 
!     Integer and 8-byte Real data. Data are generated internally
!     by the Fortran 90-provided random generator.
! ----------------------------------------------------------------------
      Use                       numerics
      Implicit                  None

      Integer, Allocatable   :: idata(:), src(:)
      Real(l_),  Allocatable :: ddata(:)
      Real(l_)               :: speed1, speed2, time1, time2, wclock, 
     &                          cor, dlog2
      Integer                :: i, n, nops, nrep
      Logical                :: ok1, ok2
! ---------------------------------------------------------------------
      Call state( 'qsort   ' )
      Open( 1, File = 'qsort.in' )
      Print 1000
   10 Read( 1, *, End = 20 ) n, nrep
      Allocate( idata(n), ddata(n), src(n) )
      Call ranint( 1, n, n, src )
      nops  = Int( n*dlog2( n ) )         ! --- Average work estimate!!

      time1 = wclock()                    ! --- Integer sort.
      Do i = 1, nrep
         idata = src
         Call iqsort( idata, n, 1, n )
      End Do
      time1 = wclock() - time1
      time2 = wclock()                    ! --- 8-byte Real sort.
      Do i = 1, nrep
         ddata = Real( src, l_ )
         Call dqsort( ddata, n, 1, n )
      End Do
      time2 = wclock() - time2

      ok1 = .TRUE.
      ok2 = .TRUE.
      Call icheck( idata, n, ok1 )        ! --- Correctness checks.
      Call dcheck( ddata, n, ok2 )

      cor = wclock()                      ! --- Correct timings.
      Do i = 1, nrep
         idata = src
      End Do
      time1 = time1 - wclock() + cor
      cor = wclock()
      Do i = 1, nrep
         ddata = Real( src, l_ )
      End Do
      time2 = time2 - wclock() + cor
      
      speed1 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time1, 1.0e-9_l_ )
      speed2 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time2, 1.0e-9_l_ )
      Print 1010, n, time1/nrep, speed1, ok1, time2/nrep, speed2, ok2  
      Deallocate( idata, ddata , src )
      Go To 10
   20 Print 1020
! ---------------------------------------------------------------------
 1000 Format( 'Quicksort test:'/
     &        '-------------------------------------------------------',
     &        '----------------'/,
     &        '  Order |  Integer   |  Integer  |     |   Double   |',
     &        '  Double   |     |'/,
     &        '    n   |  Time (s)  |  (Mop/s)  | OK? |  Time (s)  |',
     &        '  (Mop/s)  | OK? |'/,
     &        '-------------------------------------------------------',
     &        '----------------' )
 1010 Format( i7,' |', g11.4,' |', g11.4, '|', l3,'  |', g11.4,
     &        ' |', g11.4, '|', l3, '  |' )
 1020 Format( '-------------------------------------------------------',
     &        '----------------' )
c ----------------------------------------------------------------------
      End Program qsort
