      Subroutine csetup
c ----------------------------------------------------------------------
c --- 'csetup' initializes the communication for MPI programs.
c
c --- Output parameters (in Common /dist/):
c     Integer: me    --- Local node number (0 <= me <= nodes-1).
c     Integer: nodes --- Number of nodes as found in the MPI system.
c ----------------------------------------------------------------------
      Include       'mpif.h'

      Integer       info

      Integer       me, nodes
      Common /dist/ me, nodes
c ----------------------------------------------------------------------
c --- Initialize MPI also, initialize this processor and the set of 
c     processors for this job. (In case of problems, report and stop).
c ----------------------------------------------------------------------

      Call Mpi_Init( info )
      If ( info .NE. Mpi_Success ) Then
         Print *, 'Could not initialize MPI, ierr = ', info
         Stop 'Csetup stage 1'
      End If
      Call Mpi_Comm_Rank( Mpi_Comm_World, me, info )
      If ( info .NE. Mpi_Success ) Then
         Print *, 'Could not find my process id, ierr = ', info
         Stop 'Csetup stage 2'
      End If
      Call Mpi_Comm_Size( Mpi_Comm_World, nodes, info )
      If ( info .NE. Mpi_Success ) Then
         Print *, 'Could not determine no. of nodes, ierr = ', info
         Stop 'Csetup stage 3'
      End If
c ----------------------------------------------------------------------
c --- Be sure that all processors start together.

      Call Mpi_Barrier( Mpi_Comm_World, info )
c ----------------------------------------------------------------------
      End
