      Program linspar
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the Euroben Efficiency Benchmark       ***
! ***                                                                ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, High Perf. Computing Group      ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Email: steen@phys.uu.nl                                        ***
! *** Date :                  Summer 2005                            ***
! **********************************************************************
! ----------------------------------------------------------------------
! --- Purpose of program linspar
! -----------------------------
! --- Solver for sparse linear systems with an iterative method and
!     one type of preconditioner. The systems are not actually
!     solved but rather a predifined number of iterations is performed
!     to assess the speed of the solver-preconditioner combination.
!
!     Solver used:
!     - TFQMR with polynomial preconditioning.
! ----------------------------------------------------------------------
      Use                       numerics
      Use                       floptime
      Implicit                  None

      Integer, Allocatable   :: indx(:), rowp(:)
      Real(l_), Allocatable  :: matvals(:), b(:), tq(:), x(:)
      Real(l_)               :: corr, maxdf, mindf, res
      Real(l_)               :: frac, mflops, resnrm, time
      Integer, Parameter     :: m = 1, maxit = 50
      Real(l_), Parameter    :: tol = 1.0e-10_l_
      Real(l_), Parameter    :: micro = 1.0e-6_l_, two = 2.0_l_,
     &                          perc = 1.0e2_l_
      Real(l_)               :: gamma(m+1)
      Integer                :: i, ncols, nrows, nelmts, nrep1
      Logical                :: ok
      External               :: lpolyn

      Integer, Parameter    :: nmax = 50, k = 4
      Integer               :: ic
      Real(l_)              :: size(0:nmax-1), speedcase(0:nmax-1)
      Real(l_)              :: q(0:6,0:nmax+1), aw(0:3,0:3), d(0:3,0:3),
     &                         extra(0:1), result
      Real(l_), Parameter   :: eps = 5.0e-4, fraction = 0.2
      Real(l_)              :: low, up, tpp
      Real(l_)              :: tkn, bcoef
      Common /coeffs/          tkn(0:nmax+5), bcoef(0:nmax+1)
!
! --- External Functions
!     ------------------
      External                 autint, spoint
      Real(l_)              :: autint, spoint
! ----------------------------------------------------------------------
      Call state( 'linspar ' )
      Open( 1, File = 'linspar.in' )
! ----------------------------------------------------------------------
      Read( 1, * ) tpp 
      Read( 1, * ) low, up
      Print 1000,  low, up, tpp
      ic = 0
      Print 1005
   10 Read( 1, *, End = 20 ) ncols, nrows, nelmts, nrep1
         Allocate( indx(nelmts), rowp(nrows+1), matvals(nelmts),
     &             b(ncols), tq(nrows), x(nrows) )
         Call getmatvec( nrows, nelmts, indx, rowp, matvals, b )
         Call pcoefs( m, gamma )
         q = 1.0_l_
         flops = 0
         time = wclock()
         Do i = 1, nrep1
            x = 0.0_l_
!           resnrm = -1.0_l_
            Call tfqmr( nrows, nelmts, m, indx, rowp, matvals, tq, x, b,
     &                  gamma, maxit, tol, resnrm, lpolyn )
         End Do
         time = wclock() - time
         mflops = micro*Real( flops, l_ )/time
         time   = time/Real( nrep1, l_ )
         frac   = perc*Real( nelmts, l_ )/Real( ncols*nrows, l_ )
         Print 1010, ncols, nrows, frac, time, mflops, resnrm
         Deallocate( indx, rowp, matvals, b, tq, x )
         size(ic)      = Real( nrows, l_ )
         speedcase(ic) = mflops
         ic = ic + 1
      Go To 10
   20 Print 1020
      Call bsplcf( size, speedcase, ic, k, 'FREE', extra, q, aw, d, tkn,
     &             bcoef )
      result = autint( spoint, low, up, eps )
      result = result/((up - low)*tpp)
      Print 1030, result, fraction
! ----------------------------------------------------------------------
 1000 Format( 'Sparse iterative solver test'/
     &        'Lower bound       =', g13.5/
     &        'Upper bound       =', g13.5/
     &        'Theor. Peak Perf. =', g13.5, ' Mflop/s'//
     &        'Non-symmetric, CRS: TFQMR with polyn. preconditioner.' )
 1005 Format( '-------------------------------------------------------',
     &        '-----------'/
     &        ' #Rows | #Cols | %Fill |   Time(s)   |   Mflop/s   |   R'
     &        'esidue   |'/
     &        '-------------------------------------------------------',
     &        '----------|' )
 1010 Format( i7, '|', i7, '|', f6.2, ' |', g13.5, '|', g13.5, '|',
     &        g13.5, '|' )
 1020 Format( '-------------------------------------------------------', 
     &        '-----------' )
 1030 Format( /'Fraction found = ', g11.4, '  Fraction required = ',
     &        g11.4 )
! ----------------------------------------------------------------------
      End Program linspar
