      Subroutine check( x, n, ok )
! ---------------------------------------------------------------------
! --- Routine 'check' checks the solution vector 'x' in 'b = Ax'. The
!     check is possible because of the special definition of 'A' & 'b'.
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n
      Real(l_) :: x(n)
      Logical  :: ok

      Integer  :: i
      Real(l_) :: eps
! ---------------------------------------------------------------------
      eps = 4.0_l_*n**2*Epsilon( 1.0_l_ )
      Do i = 1, n
         ok = ok .AND. ( Abs( x(i) - 1.0_l_ ) <= eps )
      End Do
! ---------------------------------------------------------------------
      End Subroutine check            
