      Subroutine mvddot( a, b, c, m, n )
! ----------------------------------------------------------------------
! --- Routine 'mvddot' does a matrix-vector multiplication 'Ab = c'
!     using a dotproduct implementation. We use some unrolling and
!     blocking because most processors/compilers seem to like it.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Integer  :: m, n
      Real(l_) :: a(m,n), b(n), c(m)

      Integer  :: i, j, kl, kh, mf, mi, nf
! ----------------------------------------------------------------------
      c  = 0.0_l_
      mi = m/64
      mf = m - Mod( m, 64 )
      nf = n - Mod( n, 4 )
      kl = -63; kh = 0
      Do i = 1, mi
         kl = kl + 64; kh = kh + 64
         Do j = 1, nf, 4
            c(kl:kh) = c(kl:kh) +  a(kl:kh,j)*b(j) + a(kl:kh,j+1)*b(j+1)
     &                      +  a(kl:kh,j+2)*b(j+2) + a(kl:kh,j+3)*b(j+3)
         End Do
      End Do
      Do i = mf + 1, m
         Do j = 1, nf, 4
            c(i) = c(i) +  a(i,j)*  b(j)   + a(i,j+1)*b(j+1)
     &                  +  a(i,j+2)*b(j+2) + a(i,j+3)*b(j+3)
         End Do
         Do j = nf + 1, n
            c(i) = c(i) + a(i,j)*b(j)
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine mvddot
