      Program gmxv
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Efficiency Benchmark       ***
! ***                                                                ***
! *** Copyright: European Benchmark Group p/o                        ***
! ***            Utrecht University, High Perf. Computing Group      ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Email: steen@phys.uu.nl                                        ***
! *** Date:  Spring 1998, modified Spring 2005                       ***
! **********************************************************************
! ----------------------------------------------------------------------
! --- Program 'gmxv' does a dense matrix-vector multiplication in two
!     ways: dotproduct and vector-update.
!     The size of the matrix and vector are read and they are generated
!     internally.
! ----------------------------------------------------------------------
      Use                      numerics
      Implicit                 None

      Real(l_), Allocatable :: a(:,:), b(:), c(:)
      Integer               :: i, m, n, nops, nrep
      Integer               :: lib
      Real(l_)              :: speed1, time1, speed2, time2, wclock
      Logical               :: ok1, ok2
! ----------------------------------------------------------------------
      Call state( 'gmxv    ' )
      Open( 1, File = 'gmxv.in' )
      Read( 1, * ) lib
      If ( lib == 0 ) Then
         Print 1000
      Else
         Print 1005
      End If
   10 Read( 1, *, End = 20 ) m, n, nrep
      Allocate( a(m,n), b(n), c(m) )
      nops = 2*m*n
      Call gendat( a, b, m, n )               ! --- Generate data.
      If ( lib == 0 ) Then
         time1 = wclock()                     ! --- Time MxV mult.
         Do i  = 1, nrep
            Call mvddot( a, b, c, m, n )
         End Do
         time1 = wclock() - time1
         ok1 = .TRUE.
         Call check( c, m, n, ok1 )           ! --- Correctness check.
         time2 = wclock()                        
         Do i  = 1, nrep
            Call mvaxpy( a, b, c, m, n )
         End Do
         time2 = wclock() - time2
         ok2 = .TRUE.
         Call check( c, m, n, ok2 )           ! --- Correctness check.

         speed1 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time1, 1.0e-9_l_)
         speed2 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time2, 1.0e-9_l_)
         Print 1010, n, m, time1/nrep, speed1, ok1, time2/nrep, speed2,
     &               ok2
      Else
         time2 = wclock()                  ! --- Time MxV mult.
         Do i  = 1, nrep
            Call dgemv( 'n', m, n, 1.0_l_, a, m, b, 1, 0.0_l_, c, 1 )
         End Do
         time2 = wclock() - time2
         ok2 = .TRUE.
         Call check( c, m, n, ok2 )           ! --- Correctness check.
         speed2 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time2, 1.0e-9_l_)
         Print 1015, n, m, time2/nrep, speed2, ok2
      End If
      Deallocate( a, b, c )
      Go To 10
   20 If ( lib == 0 ) Then
         Print 1020
      Else
         Print 1025
      End If
! ---------------------------------------------------------------------
 1000 Format( 'Matrix-vector multiplication test:'/
     &        '-----------------------------------------------------',
     &        '-------------------------'/,
     &        ' Problem size|  MxV-ddot  |  MxV-ddot  |     |',
     &        '   MxV-axpy |  MxV-axpy  |     |'/,
     &        '   m  |   n  |  Time (s)  |  (Mflop/s) | OK? |',
     &        '  Time (s)  |  (Mflop/s) | OK? |'/, 
     &        '-----------------------------------------------------',
     &        '-------------------------' )
 1005 Format( 'Matrix-vector multiplication test (library version):'/
     &        '-----------------------------------------------------'/
     &        ' Problem size|  MxV-lib.  |  MxV-lib.  |     |'/
     &        '   m  |   n  |  Time (s)  |  (Mflop/s) | OK? |'/
     &        '----------------------------------------------' )
 1010 Format( i5, ' |', i5, ' |', g11.4,' |', g11.4, ' |', l3, '  |',
     &        g11.4,' |', g11.4, ' |', l3, '  |' )
 1015 Format( i5, ' |', i5, ' |', g11.4,' |', g11.4, ' |', l3, '  |' )
 1020 Format( '-----------------------------------------------------'
     &        '-------------------------' )
 1025 Format( '----------------------------------------------' )
! ----------------------------------------------------------------------
      End Program gmxv
