      Program gmxm
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Efficiency Benchmark       ***
! ***                                                                ***
! *** Copyright: European Benchmark Group p/o                        ***
! ***            Utrecht University, High Perf. Computing Group      ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Email: steen@phys.uu.nl                                        ***
! *** Date:  Spring 1998                                             ***
! **********************************************************************
! ----------------------------------------------------------------------
! --- Program 'gmxm' does a matrix multiplication on dense matrices.
!     The size of the matrices is read and the data are generated
!     internally.
! ----------------------------------------------------------------------
      Use                     numerics
      Implicit                None

      Real(l_), Allocatable :: a(:,:), b(:,:), c(:,:)
      Integer               :: i, l, m, n, nops, nrep
      Integer               :: lib
      Real(l_)              :: speed, time1, wclock
      Logical               :: ok
! ----------------------------------------------------------------------
      Call state( 'gmxm    ' )
      Open( 1, File = 'gmxm.in' )
      Read( 1, * ) lib
      If ( lib == 0 ) Then
         Print 1000
      Else
         Print 1005
      End If
   10 Read( 1, *, End = 20 ) m, l, n, nrep
      Allocate( a(m,l), b(l,n), c(m,n) )
      nops = 2*m*l*n
      Call gendat( a, b, m, l, n )            ! --- Generate data.

      If ( lib == 0 ) Then
         time1 = wclock()                     ! --- Time matrix mult.
         Do i  = 1, nrep
            Call mxm( a, b, c, m, l, n )
         End Do
         time1 = wclock() - time1
      Else
         time1 = wclock()                     ! --- Time matrix mult.
         Do i  = 1, nrep
            Call dgemm( 'n', 'n', m, n, l, 1.0_l_, a, m, b, l, 0.0_l_,
     &                   c, m )
         End Do
         time1 = wclock() - time1
      End If
      speed = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time1, 1.0e-9_l_ )
      ok = .TRUE.
      Call check( c, m, l, n, ok )            ! --- Correctness check.
      Print 1010, n, l, m, time1/nrep, speed, ok
      Deallocate( a, b, c )
      Go To 10
   20 Print 1020
! ---------------------------------------------------------------------
 1000 Format( 'Matrix multiplication test:'/
     &        '-----------------------------------------------------'/,
     &        '     Problem size   | Execution  |    Speed   |     |'/,
     &        '   m  |   l  |   n  |  Time (s)  |  (Mflop/s) | OK? |'/, 
     &        '-----------------------------------------------------' )
 1005 Format( 'Matrix multiplication test (library version):'/
     &        '-----------------------------------------------------'/,
     &        '     Problem size   | Execution  |    Speed   |     |'/,
     &        '   m  |   l  |   n  |  Time (s)  |  (Mflop/s) | OK? |'/, 
     &        '-----------------------------------------------------' )
 1010 Format( i5, ' |', i5, ' |', i5, ' |', g11.4,' |', g11.4,
     &        ' |', l3, '  |' )
 1020 Format( '-----------------------------------------------------' )
! ----------------------------------------------------------------------
      End Program gmxm
