      Subroutine gendat( a, n )
! ----------------------------------------------------------------------
! --- Routine 'gendat' generates the test data for the FFT:
!     one complete cosine cycle in the Real part of the data.
!     Zero in the imaginary part of the data.
! ----------------------------------------------------------------------
      Use              numerics
      Implicit         None

      Integer       :: n
      Real(l_)      :: a(0:n-1)

      Real(l_)      :: fac
      Integer       :: i
! ----------------------------------------------------------------------

      fac   = 8.0_l_*Atan( 1.0_l_ )/( 1.0_l_*n )
      
      Do i = 0, n - 1
         a(i) = Cos( i*fac )
      End Do
! ----------------------------------------------------------------------
      End Subroutine gendat 
