      Subroutine check( a, b,  m, n, ierr )
! ----------------------------------------------------------------------
! --- 'check' checks the errors made in the transformation of a
!     complex-to-complex FFT. 'check' is specific for the input as given 
!     in program 'mod2f':
!     The Real part is a full cycle of a cosine signal and the Imaginary
!     part is 0.0 everywhere.
!     The resulting transform should show values of float(n/2) for 'a(2)' 
!     and 'a(n)'. All other entrie should be 0.0. This is checked below
!     with a Floating-Point error margin of 'err = ( 10*n log n )*eps',
!     with 'eps' the Floating-Point spacing of the machine tested.
!
! --- The Real part of A is stored in a(1), ..., a(n);
!     the Imaginary part in b(1), ..., b(n).
!
! --- The elements that not meet the error criterion are normally
!     NOT printed. However, by decommenting the appropriate lines
!     all offending entries are printed. When the error criterion 
!     is exceeded by an element of 'a' and/or 'b', the output parameter
!     'ierr' is increased by 1, So, after completion the total number
!     of errors is available in 'ierr'.
! ----------------------------------------------------------------------
      Use              numerics

      Integer       :: m, n, ierr
      Real(l_)      :: a(n), b(n)

      Integer       :: i
      Real(l_)      :: chkval
! ----------------------------------------------------------------------
      ierr = 0
      err  = n*m*1.0E-10_l_
! ----------------------------------------------------------------------
! --- First check Imaginary elements (All these should be about 0.0).

      chkval = 0.0_l_
      Do i = 1, n
         If ( Abs( b(i) ) > err ) Then
            Print 1040, n, i, b(i), err, chkval
            ierr = ierr + 1
         End If
      End Do
! ----------------------------------------------------------------------
! --- Check Real elements that should be about 0.0.

      i = 1
      If ( Abs( a(i) ) > err ) Then
          Print 1010, i, a(i), err
          ierr = ierr + 1
      End If
      Do i = 3, n - 1
         If ( Abs( a(i) ) > err ) Then
             Print 1010, n, i, a(i), err, chkval
             ierr = ierr + 1
          End If
      End Do
! ----------------------------------------------------------------------
! --- Check Real elements that should be about float( n/2 ).

      chkval = Real( n, l_ )/2.0_l_ 
      i = 2
      If ( Abs( a(i) - chkval ) > err ) Then
         Print 1020, n, a(i), chkval
         ierr = ierr + 1
      End If
      i = n
      If ( Abs( a(i) - chkval ) > err ) Then
         Print 1030, n, a(i), chkval
         ierr = ierr + 1
      End If
! ----------------------------------------------------------------------
 1010 Format( 'Real element, Transform length = ', I7, 
     &        ' Element no. = ', I7, ' Value = ', 1Pg11.3,
     &        ' Should be <= ', 1Pg11.3 )
 1020 Format( 'Second Real element, Transform length = ', I7, 
     &        ' Value = ', 1Pg11.3, ' Should be ', 1Pg11.3 )
 1030 Format( 'N-th Real element, Transform length = ', I7,
     &        ' Value = ', 1Pg11.3, ' Should be ', 1Pg11.3 ) 
 1040 Format( 'Imaginary element, Transform length = ', I7,
     &        ' Element no. = ', I7, ' Value = ', 1Pg11.3,
     &        ' Should be <= ', 1Pg11.3 )
! ----------------------------------------------------------------------
      End Subroutine check
