      Subroutine trans_2d( title, me, npes, nrpt, ncases, n, tn,
     &                    ops )
! ----------------------------------------------------------------------
      Use             numerics
      Use             max_params      
      Implicit        None     
      Include         'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer 
      Real(l_)     :: a(nmax), b(nmax)      
      Real(l_)     :: t1, t2
      Integer      :: s_pe, r_pe
      Integer      :: k, kk, kb
      Integer      :: st(MPI_Status_Size)
      Integer      :: comm, ie, rtag, stag, type
      Save            a, b
! ---------------------------------------------------------------------- 
      comm   = MPI_Comm_World
      type   = MPI_Real8
      title  = ' N PEs  <--  N PEs; Trans 2D'
      nrpt   = 100
      ncases = npes
      ops    = npes*8*n
      tn(1:ncases) = 0.0_l_      
      If ( n > nmax/npes ) Then
         ncases = 0
         Return
      End If
      Do k = 1,ncases      
        Call MPI_Barrier( comm, ie )      
        t1 = timer()
        Do kk = 1, nrpt 
           Do kb = 0, npes-1
              r_pe = Mod( me+kb, npes )
              s_pe = Mod( me-kb+npes, npes )
              stag = s_pe*nrpt + kk
              rtag = me*nrpt + kk
              Call MPI_Sendrecv( a(me*n), n, type, s_pe, stag, 
     &             b(r_pe*n), n, type, r_pe, rtag, comm, st, ie )
           End Do
        End Do
        t2    = timer()
        tn(k) = (t2 - t1)/(2*nrpt)
      End Do
! ----------------------------------------------------------------------  
      End Subroutine trans_2d
