      Subroutine stats_pe( npes, ncases, tn, ops,
     &                     Xi_t, tmin, tave, tmax,
     &                     Xi_r, rmin, rave, rmax )
! ----------------------------------------------------------------------
      Use         numerics
      Use         max_params
      Implicit    none
      Include     'mpif.h' 

      Integer  :: npes, ncases, type
      Real(l_) :: tn(ncases), ops
      Real(l_) :: Xi_t, tmn, tmin, tave, tmx, tmax
      Real(l_) :: Xi_r, rmn, rmin, rave, rmx, rmax      
      Real(l_) :: tot_t, tot_t2, t_t, t_t2
      Real(l_) :: tot_r, tot_r2, t_r, t_r2
      Real(l_) :: rn
      Integer  :: comm, ie, k, me
! ----------------------------------------------------------------------      
      comm = MPI_Comm_World
      type = MPI_Real8
      Call MPI_Comm_Rank( comm, me, ie )
      
      tmin = tn(1)
      tmax = tn(1)
      rmin = ops/tn(1)
      rmax = ops/tn(1)
      tot_t  = 0.0_l_
      tot_t2 = 0.0_l_
      tot_r  = 0.0_l_
      tot_r2 = 0.0_l_
      Do k = 1, ncases
         tot_t  = tot_t  + tn(k)
         tot_t2 = tot_t2 + tn(k)*tn(k)
         tmn    = Min( tmin, tn(k) )
         tmx    = Max( tmax, tn(k) )

         rn     = ops/tn(k)
         tot_r  = tot_r  + rn
         tot_r2 = tot_r2 + rn*rn
         rmn    = Min( rmin, rn )
         rmx    = Max( rmax, rn )
      End Do
      
      Call MPI_Barrier( comm, ie )
      Call MPI_Allreduce( tot_t,  t_t,  1, type, MPI_Sum, comm, ie )
      Call MPI_Allreduce( tot_t2, t_t2, 1, type, MPI_Sum, comm, ie )
      Call MPI_Allreduce( tot_r,  t_r,  1, type, MPI_Sum, comm, ie )
      Call MPI_Allreduce( tot_r2, t_r2, 1, type, MPI_Sum, comm, ie )
      
      tave = t_t/(ncases*npes)
      rave = t_r/(ncases*npes)

      Call MPI_Barrier( comm, ie )
      Call MPI_Allreduce( tmn, tmin, 1, type, MPI_Min, comm, ie )
      Call MPI_Allreduce( tmx, tmax, 1, type, MPI_Max, comm, ie )
      Call MPI_Allreduce( rmn, rmin, 1, type, MPI_Min, comm, ie )
      Call MPI_Allreduce( rmx, rmax, 1, type, MPI_Max, comm, ie )

      Xi_t = Sqrt( (t_t2-(ncases*npes)*tave**2)/
     &             Max( (ncases*npes), 1 ) )
      Xi_r = Sqrt( (t_r2-(ncases*npes)*rave**2)/
     &             Max( (ncases*npes), 1 ) )
! ----------------------------------------------------------------------
      End Subroutine stats_pe
