      Subroutine stats_agg( npes, ncases, tn, ops, Xi_t, tmin, tave,
     &                      tmax, Xi_r, rmin, rave, rmax )
! ----------------------------------------------------------------------
      Use         numerics
      Use         max_params
      Implicit    None
      Include     'mpif.h'

      Integer  :: npes, ncases
      Real(l_) :: tn(1:ncases), ops
      Real(l_) :: Xi_t, tmin, tave, tmax
      Real(l_) :: Xi_r, rmin, rave, rmax     
      Real(l_) :: tot_t, tot_t2
      Real(l_) :: tot_r, tot_r2
      Real(l_) :: rn, tnk
      Integer  :: comm, k, ie, mip, type 
! ----------------------------------------------------------------------      
      comm = MPI_Comm_World
      type = MPI_Real8
      Call MPI_Barrier( comm, ie )
      Do k = 1,ncases
         Call MPI_Allreduce( tn(k), tnk, 1, type, MPI_Max, comm, ie )
         tn(k) = tnk
      End Do

      tmin = tn(1)
      tmax = tn(1)
      rmin = ops/tn(1)
      rmax = ops/tn(1)
      tot_t = 0.0_l_
      tot_t2= 0.0_l_
      tot_r = 0.0_l_
      tot_r2= 0.0_l_
      Do k = 1,ncases
         tot_t  = tot_t + tn(k)
         tot_t2 = tot_t2+ tn(k)*tn(k)
         tmin   = Min( tmin, tn(k) )
         tmax   = Max( tmax, tn(k) )
         rn     = ops/tn(k)
         tot_r  = tot_r + rn
         tot_r2 = tot_r2+ rn*rn
         rmin   = Min( rmin, rn )
         rmax   = Max( rmax, rn )
      End Do
      tave = tot_t/ncases
      rave = tot_r/ncases
      Xi_t = Sqrt( (tot_t2-ncases*tave**2)/Max( ncases, 1 ) )
      Xi_r = sqrt( (tot_r2-ncases*rave**2)/Max( ncases, 1 ) )
! ---------------------------------------------------------------------- 
      End Subroutine stats_agg
