      Subroutine report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                   first, last )
! ----------------------------------------------------------------------
      Use             numerics
      Use             max_params
      Implicit        None
      Include         'mpif.h'

      Character*50 :: title
      Real(l_)     :: Xi_t, tmin, tave, tmax
      Real(l_)     :: Xi_r, rmin, rminl, rave, ravel, rmax, rmaxl
      Real(l_)     :: tn(maxcases), ops
      Integer      :: nrpt, ncases
      Integer      :: me, npes, n
      Integer      :: comm, ie
      Logical      :: first, last
      Save            rminl, ravel, rmaxl
! ----------------------------------------------------------------------
         comm = MPI_Comm_World
         If ( me == 0 .AND. first ) Then
            Write(6,9010) title, npes, nrpt, ncases
            first = .FALSE.
         End If
         If ( ncases > 0 ) Then
            Call MPI_Barrier( comm, ie )
            Call stats_pe(  npes, ncases, tn, ops, Xi_t, tmin, tave,
     &                      tmax, Xi_r, rmin, rave, rmax )
            Call stats_agg( npes, ncases, tn, ops, Xi_t, tmin, tave,
     &                      tmax, Xi_r, rmin, rave, rmax )
            rminl = rmin
            ravel = rave
            rmaxl = rmax
            If ( me == 0 ) Then
               Write(6,9020) 8*n, Xi_t*1.0e6_l_, tmin*1.0e6_l_,
     &                            tave*1.0e6_l_, tmax*1.0e6_l_,
     &                            Xi_r*1.0e-6_l_, rmin*1.0e-6_l_,
     &                            rave*1.0e-6_l_, rmax*1.0e-6_l_
            End If
         End If
         If ( me == 0 .AND. last ) Then
            Write(6,9030) rminl*1.0e-6_l_, ravel*1.0e-6_l_,
     &                   rmaxl*1.0e-6_l_, 'Aggregate'
            last = .FALSE.
            first = .TRUE.
         End If
! ----------------------------------------------------------------------
 9010 Format(
     &      //' Communication: ', A
     &       /' Number of PEs:                ', i8
     &       /' Iteration count :             ', i8
     &       /' Number of cases:              ', i8 
     &      //'  Length', 2x, '          Time (Microsec.)     ',
     &                    2x, '            Rate (Mbyte/s)     '
     &       /'   Bytes', 2x, '  Std Dev    Min     Ave     Max',
     &                    2x, '  Std Dev    Min     Ave     Max'
     &       /1x, 75( '-' ) )

 9020 Format( i8, 2x, 4f8.1, 2x ,f8.1, 3f8.0 )
 9030 Format( /' Rmin:  ', f8.0, ' Mbyte/s'
     &        /' Rave:  ', f8.0,
     &        /' Rmax:  ', f8.0,
     &       //' Statistics: ', a/ )            
! ----------------------------------------------------------------------
      End Subroutine report
