      Subroutine nearn_1d( title, me, npes, nrpt, ncases, n, tn,
     &                        ops )
! ----------------------------------------------------------------------
      Use            numerics
      Use            max_params      
      Implicit       None
      
      Include        'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax), b(nmax), c(nmax)      
      Real(l_)     :: buffer( 4*(nmax + MPI_Bsend_Overhead/8 ))
      Real(l_)     :: t1, t2
      Integer      :: k, tag
      Integer      :: comm, commcart, ie, type
      Integer      :: status(MPI_Status_Size)
      Integer, Parameter :: dim = 1
      Integer      :: dims(dim), npos(dim)
      Integer      :: pos(dim)
      Logical      :: periods(dim)
      Integer      :: moi, myid
      Integer      :: west, east
      Integer      :: size
      Save            a, b, c
! ----------------------------------------------------------------------
      comm    = MPI_Comm_World
      type    = MPI_Real8
      title   = ' N PEs  <--  2N PEs; Nearst nbr 1D'
      nrpt    = 100
      ncases  = npes
      ops     = 2*8*n
      size    = 8*n 
      tn(1:ncases) = 0.0_l_
      
      periods = .TRUE.                        ! --- Introduce topology
      dims    = 0   
      Call MPI_Comm_Rank( comm, myid, ie)
      Call MPI_Dims_Create( npes, dim, dims, ie )      
      Call MPI_Cart_Create( comm, dim, dims, periods, .TRUE.,
     &                      commcart, ie )
      
! --- Get position and rank in Cartesian grid.
      
      Call MPI_Cart_Get( commcart, dim, dims, periods, pos, ie )
      Call MPI_Cart_Rank( commcart, pos, moi, ie )     
      Call MPI_Buffer_Attach(buffer, 4*(size+MPI_Bsend_Overhead), ie )
      
! --- Get rank of neighbours.
        
      Call MPI_Cart_Coords( commcart, myid, dim, dims, ie )
      Call MPI_Cart_Shift( commcart, 0, -1, myid, west, ie )       
      Call MPI_Cart_Shift( commcart, 0, 1,  myid, east, ie )
      Call MPI_Barrier( commcart, ie )
      t1 = timer()
      Do k = 1, nrpt
         tag = (k * npes * 2)
         Call MPI_Bsend( a, n, type, west, tag + moi,    commcart, ie )
         Call MPI_Bsend( a, n, type, east, tag + moi + 1,commcart, ie )
         Call MPI_Recv( b, n, type, west, tag + west + 1,
     &                  commcart, status, ie )
         Call MPI_Recv( c, n, type, east, tag + east,
     &                  commcart, status, ie )
      End Do
      t2       = timer()
      tn (myid+1) = (t2-t1) / (2*nrpt)
      Call MPI_Buffer_Detach( buffer, size, ie )
! ----------------------------------------------------------------------
      End Subroutine nearn_1d
