      Subroutine  bisec2_reg( title, me, npes, nrpt, ncases, n, tn,
     &                        ops )
! ----------------------------------------------------------------------
      Use            numerics
      Use            max_params      
      Implicit       None
      
      Include        'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax), b(nmax)      
      Real(l_)     :: t1, t2
      Integer      :: source, target
      Integer      :: k, kk, n_er, nph
      Integer      :: comm, ie, rtag, stag, type
      Integer      :: status(MPI_Status_Size)
      Save            a, b
! ----------------------------------------------------------------------
      comm   = MPI_Comm_World
      type   = MPI_Real8
      title  = ' N/2 PEs<--  N/2 PEs; Bisect., Unidir., Regular'
      nrpt   = 50
      ops    = 8*n
      nph    = npes/2
      ncases = nph
      a      = 1.0_l_
      b      = 0.0_l_
      tn (1:ncases) = 0.0_l_ 

      Do k = 0, nph - 1
         If ( me < nph ) Then
            target = Mod( me + k, nph ) + nph
         Else
            source = Mod( me - k, nph )
         End If
         stag = 11111
  
         t1 = timer()
         Do kk = 0, nrpt-1
            stag = stag + kk
            rtag = stag + 1
            If ( me < nph ) Then
               Call MPI_Send(a, n, type, target, stag, comm, ie)
               Call MPI_Recv(b, n, type, target, rtag, comm, status, ie)
            Else
               Call MPI_Recv(b, n, type, source, stag, comm, status, ie)
               Call MPI_Send(a, n, type, source, rtag, comm, ie)
            End If
         End Do
         Do kk = 0, nrpt-1
            stag = stag + 1
            rtag = stag + 1
            If ( me < nph ) Then
               Call MPI_Recv(b, n, type, target, rtag, comm, status, ie)
               Call MPI_Send(a, n, type, target, stag, comm, ie)
            Else
               Call MPI_Send(a, n, type, source, rtag, comm, ie)
               Call MPI_Recv(b, n, type, source, stag, comm, status, ie)
            End If
         End Do
         t2     = timer()
         tn (k+1) = ( t2 - t1 )/( 4*nrpt )
      End Do
! ----------------------------------------------------------------------
      End
