      Function spoint( x )                             Result( result )
! ----------------------------------------------------------------------
C
C SPOINT CALCULATES THE VALUES OF THE SPLINE INTERPOLATING THE SEQUENCE
C (X(I),Y(I)), I=0,...,N-1. THE SPLINE IS GIVEN IN ITS B-REPRESENTATION
C T,BCOEF AND K. BCOEF AND T ARE PRODUCED BY ROUTINE BSPLCF.
C BECAUSE result IS COMPLETELY DEFINED BY BCOEF AND T, 
C THEREFORE result IS OMITTED FROM THE  PARAMETER LIST.
C
C INPUT:
C   X      : REAL abcissa of point to be interpolated.
C   T      : REAL(0:N+2*K-3). KNOT SEQUENCE USED FOR THE GENERATION OF
C                  THE B-SPLINES.
C   BCOEF  : REAL(0:N+K-3). B-SPLINE COEFFICIENTS.
C   K      : ORDER OF SPLINES.
C
C OUTPUT:
C   RESULT : REAL. Interpolation value at x.
C
C SPOINT CALLS BVALUE.
C
      Use                    numerics
      Real(l_)            :: bvalue, result, x
      Integer, Parameter  :: n = 50, k = 4
      Real(l_)            :: t(0:n+k+k-3), bcoef(0:n+k-3)
      Common /coeffs/        t, bcoef
! ----------------------------------------------------------------------
      nsize = n + k - 2

      result = bvalue( t, bcoef, nsize, k, x, 0 )
! ----------------------------------------------------------------------
      End Function spoint
