      SUBROUTINE MKNOT1(X,T,N,K,Q,BCOEF)
      Use numerics
! ---------------------------------------------------------------------
C
C MKNOT1 MAKES THE KNOT SEQUENCE T TO OBTAIN THE B-SPLINES OF ORDER
C K, USING THE SEQUENCE X(I),I=0,...,N-1 SUCH THAT THE 'NOT-A-KNOT'
C CONDITION HOLDS FOR THE END POINTS.
C THE MATRIX OF THE LINEAR SYSTEM B * BCOEF = Y IS CONSTRUCTED, WHERE
C FOR EACH I, I=0,...,N-1, B(J,K,T)(Y(I)), FOR J=LEFT-K+1,...,LEFT ARE
C THE B-SPLINES OF ORDER K, POSSIBLY NON-ZERO AT X(I), T(LEFT) <= X(I) <
C T(LEFT+1).
C BCOEF IS THE VECTOR OF B-SPLINE COEFFICIENTS OF THE SPLINE WHICH IN-
C TERPOLATES THE POINTS (X(I),Y(I)), ALL I.
C BECAUSE THE SYSTEM HAS A BAND STRUCTURE, THE SYSTEM IS STORED IN A
C CONDENSED FORM IN THE ARRAY Q. IN Q THE DIAGONALS OF THE MATRIX ARE
C REPRESENTED AS ROWS. THIS ALLOWS FOR A FAIR SAVING IN STORAGE AND
C AN EFFICIENT SOLVING PROCEDURE BY THE ROUTINES BANFAC AND BANSLV.
C
C INPUT:
C   X     : REAL(0:N-1). ABCISSAE OF THE SEQUENCE TO BE INTERPOLATED.
C   N     : LENGTH OF THE SEQUENCE.
C   K     : ORDER OF INTERPOLATION (DEGREE + 1).
C   Q     : REAL(0:2*K-2,0:N+K-3). ZEROED ARRAY TO BE FILLED WITH THE
C                  THE DIAGONALS OF THE MATRIX.
C
C WORKING AREAS:
C   BCOEF : REAL(0:N+K-3). WILL CONTAIN THE K NON-ZERO B-SPLINE VALUES
C                  B(J,K,T)(Y(I)), J=LEFT-K+1,...,LEFT FOR ALL I.
C                  (TEMPORARY STORAGE)
C
C OUTPUT:
C   T     : REAL(0:N+2*K-3). WILL CONTAIN THE KNOT SEQUENCE USED FOR
C                  CONSTRUCTION OF THE B-SPLINES B(J,K,T)(.) AS DE-
C                  SCRIBED ABOVE.
C   Q     : REAL(0:2*K-2,0:N+K-3). CONTAINS NON-ZERO DIAGONALS OF
C                  THE MATRIX OF B * BCOEF = Y, TO BE SOLVED BY BANFAC/
C                  BANSLV.
C
C MKNOT1 CALLS BSPLVB
C
! ---------------------------------------------------------------------      
      Real(l_) :: X(0:N-1),T(0:N+K+K-3),Q(0:K+K-2,0:N+K-3),
     &            BCOEF(0:N+K-3)
C
C MAKE FIRST KNOT SEQUENCE T.
C
      M=K/2
      DO 10 I=0,K-1
         T(I)=X(0)-1.0
         T(I+N)=X(N-1)+1.0
   10 CONTINUE
      DO 15 I=K,N-1
         T(I)=X(I-M)
   15 CONTINUE
C
C WE NOW FILL FOR ALL OF THE I EQUATIONS THE K NON-ZERO ENTRIES OF Q.
C
      LEFT=K-1
      DO 30 I=0,N-1
         XI=X(I)
         IUP=MIN0(I+K,N)
C
C FIND LEFT IN THE INTERVAL [I,I+K-1] S.T. T(LEFT) <= X(I) < T(LEFT+1).
C
         LEFT=MAX0(LEFT,I)
   20    IF(XI .LT. T(LEFT+1)) THEN
            CALL BSPLVB(T,K,1,XI,LEFT+1,BCOEF)
         ELSE
            LEFT=LEFT+1
            IF(LEFT .LT. IUP) THEN
               GO TO 20
            ELSE
               LEFT=LEFT-1
               CALL BSPLVB(T,K,1,XI,LEFT+1,BCOEF)
            END IF
         END IF
C
C LOOP OVER J TO FILL K NON-ZERO ENTRIES FOR THE I-TH EQUATION.
C
         DO 30 J=0,K-1
            IDIAG=LEFT+J-K+1
            Q(I-IDIAG+K-1,IDIAG)=BCOEF(J)
   30 CONTINUE
      RETURN
      END
