      SUBROUTINE BSPLCF(X,Y,N,K,MODE,EXTRA,Q,A,DY,T,BCOEF)
      Use numerics
! ---------------------------------------------------------------------
C
C BSPLCF MAKES THE B-SPLINE COEFFICIENTS OF ORDER K (K EVEN) TO INTER-
C POLATE THE SEQUENCE Y(I), I=0,...,N-1 AT THE POINTS X(I), I=0,...,N-1.
C THE END CONDITIONS FOR THE INTERPOLATION ARE DETERMINED BY THE PARA-
C METERS 'MODE' AND 'EXTRA'.
C
C INPUT:
C   X     : REAL(0:N-1). ABCISSAE OF THE SEQUENCE ON WHICH THE INTER-
C                  POLATION IS DONE.
C   Y     : REAL(0:N-1). ORDINATES OF THE SEQUENCE ON WHICH THE INTER-
C                  POLATION IS DONE.
C   N     : LENGTH OF THE SEQUENCE.
C   K     : ORDER OF INTERPOLATION (DEGREE + 1). K SHOULD BE EVEN.
C   MODE  : CHARACTER *(*).
C                  MODE ='NOT'  : NOT-A-KNOT CONDITION,I.E. X(0) AND
C                                 X(N-1) ARE NOT TREATED AS END POINTS
C                                 IN ORDER TO GET A COMPLETE LINEAR
C                                 SYSTEM ON THE INTERIOR POINTS.
C                       ='FREE' : FREE ENDS CONDITION, I.E. Y''(0),
C                                 Y''(N-1) AND ALL HIGHER DERIVATIVES
C                                 AT THE END POINTS ARE ASSUMED TO BE 0.
C                       ='BUILT': FOR M = K/2,
C                                 M-1 DERIVATIVES AT X(0) AND M-1
C                                 DERIVATIVES AT X(N-1) ARE EXPECTED,
C                                 E.G. FOR K=6, Y'(0),Y''(0),Y'(N-1)
C                                 AND Y''(N-1) SHOULD BE GIVEN.
C   EXTRA : REAL(0:K-3). ARRAY WITH EXTRA INFORMATION ON THE END POINTS
C                  ONLY USED WHEN MODE='BUILT'. FOR M = K/2 THE
C                  FIRST UP TO THE (M-1)-TH DERIVATIVE AT X(0), FOL-
C                  LOWED BY THE FIRST UP TO THE (M-1)-TH DERIVATIVE AT
C                  X(N-1) ARE EXPECTED IN THE ORDER JUST DESCRIBED.
C
C WORKING AREA:
C   Q     : REAL(0:2*K-2,0:N+K-3). ARRAY CONTAINING THE CONDENSED MATRIX
C                  OF THE SYSTEM WHICH YIELDS THE B-SPLINE COEFFI-
C                  CIENTS.
C   A     : REAL(0:K-1,0:K-1). SCRATCH-ARRAY, TO CONTAIN THE B-COEFFI-
C                  CIENTS OF THE DERIVATIVES.
C   DY    : REAL(0:K-1,0:K-1). SCRATCH-ARRAY, TO CONTAIN THE VALUES OF
C                  THE DERIVATIVES OF THE B-SPLINES.
C OUTPUT:
C   T     : REAL(0:N+2*K-3). KNOT-SEQUENCE USED FOR THE CONSTRUCTION OF
C                  THE B-SPLINES.
C   BCOEF : REAL(0:N+K-3). SEQUENCE OF B-SPLINE COEFFICIENTS TO BE USED
C                  IN THE INTERPOLATION OF (X(I),Y(I)), I=0,...,N-1.
C
C BSPLCF CALLS MKNOT1,MKNOT2,BANFAC,BANSLV
! ---------------------------------------------------------------------
      REAL(l_) :: X(0:N-1),Y(0:N-1),EXTRA(0:K-3),T(0:N+K+K-3),
     &     Q(0:K+K-2,0:N+K-3),BCOEF(0:N+K-3),A(0:K-1,0:K-1),
     &     DY(0:K-1,0:K-1)
      CHARACTER *(*) MODE
C
C BECAUSE THE LINEAR SYSTEM WILL HAVE K-2 EXTRA EQUATIONS WHEN MODE=
C 'FREE' OR MODE='BUILT' WE HAVE TO PROVIDE FOR THIS BY SETTING NSIZE
C TO THE CORRECT SIZE.
C
C
      IF(MODE .EQ. 'NOT') THEN
         NSIZE=N
      ELSE
         NSIZE=N+K-2
      END IF
C
C INITIALIZE Q.
C
      DO 10 I=0,K+K-2
         DO 10 J=0,NSIZE-1
            Q(I,J)=0.0
   10 CONTINUE
C
C FILL T AND Q ACCORDING TO 'MODE' AND 'EXTRA'.
C
      IF(MODE .EQ. 'NOT') THEN
         CALL MKNOT1(X,T,N,K,Q,BCOEF)
      ELSE IF(MODE .EQ. 'FREE' .OR. MODE .EQ. 'BUILT') THEN
         CALL MKNOT2(X,T,N,K,MODE,Q,A,DY,BCOEF)
      ELSE
         PRINT *,'UNKNOWN MODE : ',MODE
         STOP
      END IF
C
C THE CONDENSED LINEAR SYSTEM IS NOW STORED IN Q, IT WILL BE FACTORIZED
C IN AN UPPER- AND LOWER-BAND MATRIX BY BANFAC AND SOLVED FOR BCOEF
C BY BANSLV.
C
      KM1=K-1
      CALL BANFAC(Q,K+KM1,NSIZE,KM1,KM1,IFLAG)
C
C CHECK WHETHER FACTORIZATION WAS POSSIBLE.
C
      IF(IFLAG .EQ. 2) THEN
         PRINT *,'LINEAR SYSTEM FOR SPLINE INTERPOLATION NOT INVERTIBLE'
         STOP
      ELSE
         IF(MODE .EQ. 'NOT') THEN
            DO 20 I=0,N-1
               BCOEF(I)=Y(I)
   20       CONTINUE
         ELSE
            IF(MODE .EQ. 'FREE') THEN
               DO 30 I=0,K-3
                  EXTRA(I)=0.
   30          CONTINUE
            END IF
            M=K/2-1
            DO 40 I=0,M-1
               BCOEF(I)=EXTRA(I)
               BCOEF(N+M+I)=EXTRA(M+I)
   40       CONTINUE
            DO 50 I=M,N+M-1
               BCOEF(I)=Y(I-M)
   50       CONTINUE
         END IF
         CALL BANSLV(Q,K+KM1,NSIZE,KM1,KM1,BCOEF)
      END IF
      RETURN
      END
