      SUBROUTINE BANSLV(W, NROWW, NROW, NBANDL, NBANDU, B)
! ---------------------------------------------------------------------
      Use numerics

C
C   FROM  * A PRACTICAL GUIDE TO SPLINES *  BY C. DE BOOR
C   COMPANION ROUTINE TO  BANFAC . IT RETURNS THE SOLUTION  X  OF THE
C   LINEAR SYSTEM  A*X = B  IN PLACE OF  B , GIVEN THE LU-FACTORIZATION
C   FOR  A  IN THE WORKARRAY  W .
C
C ******  I N P U T  ******
C   W, NROWW,NROW,NBANDL,NBANDU.....DESCRIBE THE LU-FACTORIZATION OF A
C       BANDED MATRIX  A  OF RODER  NROW  AS CONSTRUCTED IN  BANFAC .
C       FOR DETAILS, SEE  BANFAC .
C   B.....RIGHT SIDE OF THE SYSTEM TO BE SOLVED .
C
C ******  O U T P U T  ******
C   B.....CONTAINS THE SOLUTION  X , OF ORDER  NROW .
C
C ******  M E T H O D  ******
C    (WITH  A = L*U, AS STORED IN  W,) THE UNIT LOWER TRIANGULAR SYSTEM
C   L(U*X) = B  IS SOLVED FOR  Y = U*X, AND  Y  STORED IN  B . THEN THE
C   UPPER TRIANGULAR SYSTEM  U*X = Y  IS SOLVED FOR  X  . THE CALCUL-
C   ATIONS ARE SO ARRANGED THAT THE INNERMOST LOOPS STAY WITHIN COLUMNS.
C
! ---------------------------------------------------------------------
      Integer  :: nbandl, nbandu, nrow, nroww, i, j, jmax, middle, 
     &            nrowm1
      Real(l_) :: w(nroww,nrow), b(nrow)
! ---------------------------------------------------------------------
      MIDDLE = NBANDU + 1
      IF (NROW.EQ.1) GO TO 80
      NROWM1 = NROW - 1
      IF (NBANDL.EQ.0) GO TO 30
C
C                      FORWARD PASS
C FOR I=1,2,...,NROW-1, SUBTRACT  RIGHT SIDE(I)*(I-TH COLUMN
C OF  L )  FROM RIGHT SIDE  (BELOW I-TH ROW) .
C
      DO 20 I=1,NROWM1
         JMAX = MIN0(NBANDL,NROW-I)
         DO 10 J=1,JMAX
            B(I+J) = B(I+J) - B(I)*W(MIDDLE+J,I)
   10    CONTINUE
   20 CONTINUE
C
C                      BACKWARD PASS
C FOR I=NROW,NROW-1,...,1, DIVIDE RIGHT SIDE(I) BY I-TH DIAG-
C ONAL ENTRY OF  U, THEN SUBTRACT  RIGHT SIDE(I)*(I-TH COLUMN
C OF  U)  FROM RIGHT SIDE  (ABOVE I-TH ROW).
C
   30 IF (NBANDU.GT.0) GO TO 50
C
C A  IS LOWER TRIANGULAR .
C
      DO 40 I=1,NROW
         B(I) = B(I)/W(1,I)
   40 CONTINUE
      RETURN
   50 I = NROW
   60 B(I) = B(I)/W(MIDDLE,I)
      JMAX = MIN0(NBANDU,I-1)
      DO 70 J=1,JMAX
         B(I-J) = B(I-J) - B(I)*W(MIDDLE-J,I)
   70 CONTINUE
      I = I - 1
      IF (I.GT.1) GO TO 60
   80 B(1) = B(1)/W(MIDDLE,1)
      RETURN
      END
